#ifndef _LIB_SND_H_
#define _LIB_SND_H_

#include "c4d_library.h"


#ifndef _INTERNAL_DEF_SND_

class BaseSound;

struct GeSndInfo
{
	Bool stereo;  // mono or stereo
	Bool b16;		  // 8 bit or 16 bit
	LONG f_mode;  // 0 = 11kHz, 1 = 22kHz, 2=44kHz
	LONG samples; // number of samples
	CHAR *data;   

	GeSndInfo(void) { data=NULL; }
  GeSndInfo(BaseSound *bs);
};


class GePlaySnd
{

	private:
		GePlaySnd();

	public:
		static GePlaySnd*		Alloc				();
		static void					Free				(GePlaySnd *&data);

		Bool								Open				(const GeSndInfo &si);
		void								Close				();

		void								Start				(LONG start, LONG count);
		void								Stop				();

		Bool								IsPlaying		();
		LONG								GetPosition	();
};

#else

#define GePlaySnd		GeSndOut

#endif

// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF


#define LIB_SND 1000496

struct GeSndLib : public C4DLibrary
{
		GePlaySnd*	(*Alloc)									();
		void				(*Free)										(GePlaySnd *&data);
		
		Bool				(GePlaySnd::*Open)				(const GeSndInfo &si);
		void				(GePlaySnd::*Close)				();
		void				(GePlaySnd::*Start)				(LONG start, LONG count);
		void				(GePlaySnd::*Stop)				();
		Bool				(GePlaySnd::*IsPlaying)		();
		LONG				(GePlaySnd::*GetPosition)	();
};																												
																													
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF
// INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF -- INTERNAL STUFF

#endif
